/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.fertilizer;

import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record AgriFertilizerVariant(ExtraCodecs.TagOrElementLocation item, CompoundTag nbt) {
    public static final Codec<AgriFertilizerVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_216161_.fieldOf("item").forGetter(variant -> variant.item), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(variant -> variant.nbt.m_128456_() ? Optional.empty() : Optional.of(variant.nbt))).apply((Applicative)instance, AgriFertilizerVariant::new));

    public AgriFertilizerVariant(ExtraCodecs.TagOrElementLocation item, Optional<CompoundTag> nbt) {
        this(item, nbt.orElse(new CompoundTag()));
    }

    public boolean isVariant(ItemStack itemStack) {
        List<Item> items = Platform.get().getItemsFromLocation(this.item());
        if (items.contains(itemStack.m_41720_())) {
            if (this.nbt.m_128456_()) {
                return true;
            }
            CompoundTag tag = itemStack.m_41784_();
            for (String key : this.nbt.m_128431_()) {
                if (tag.m_128441_(key) && tag.m_128423_(key).equals(this.nbt.m_128423_(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        ExtraCodecs.TagOrElementLocation item;
        CompoundTag nbt = new CompoundTag();

        public AgriFertilizerVariant build() {
            return new AgriFertilizerVariant(this.item, this.nbt);
        }

        public Builder item(String location) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), false);
            return this;
        }

        public Builder item(String namespace, String path) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), false);
            return this;
        }

        public Builder tag(String location) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), true);
            return this;
        }

        public Builder tag(String namespace, String path) {
            this.item = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), true);
            return this;
        }

        public Builder nbt(CompoundTag nbt) {
            this.nbt = nbt;
            return this;
        }
    }
}

